version 18
clear
set more off
capture log close

* Use present working directory (data file must be in this directory)
pwd 

log using RetainedandReleased_Totals.log, text replace

* Retained and Released Data File Creation.do
* Created by Paul J Ferraro, 26 March 2024

*   This code was developed to create the inputs into the coventional 
* monitoring and evaluation approach that calculates the program impact by
* using the live releases (Equation 1 in the Materials and Methods section).

*   This file uses "DF_anly_1.rds" and Releases_1.rds created on 3/14/24 by 
* Thomas Pienkowski and which Ferraro turned into csv files for this do file.
* The .rds data file was created by the R project "RCT_project"

* These data files and this Stata do file are available at 
* https://osf.io/b27ja/


*  Calculate live releases of hammerheads per boat over the experimental
* periods

import delimited Release_1.csv

//* Collapse the hammerhead live releases by boat

collapse (sum) count_hh_r , by(boat)

//* Summarize the aggregated data

summarize count_hh_r, detail

//* Let's total up the sum 

display r(sum)

save HH_Releases_Totals.dta, replace

*  Calculate live releases of wedgefish per boat over the experimental
* periods

clear

import delimited Release_1.csv

//* Collapse the wedgefish live releases by boat

collapse (sum) count_wf_r , by(boat)

//* Summarize the aggregated data

summarize count_wf_r, detail

//* Let's total up the sum 

display r(sum)

save WF_Releases_Totals.dta, replace

**************************************************************************
clear

* Hammerhead retained catches and releases over the experimental periods

import delimited DF_anly_1.csv

* Create numeric variables for the analysis

egen villagen = group(village)
egen siten = group(site)

* 1=AJ (Aceh Jaya), 2=TL (East Lombok)

egen vesseln = group(boat)

egen phasen = group(phase_exp)

*   villagen 1,4 and 5 had 4-period designs and villagen 2 and 3 had 3-period
* designs

*   Tell Stata that these data are panel data at the vessel level and that 
* phasen are the time periods in order

xtset vesseln phasen

* Drop variables that are not needed for the reshaping process

drop phase_exp wf_count wf_count_norm hh_count_norm

*   Turn the long form into wide form so that each row is a vessel and the
* and the treatment and retained catch values are arranged by period across
* the columns

reshape wide hh_count day_count treatment recipient , i(vesseln) j(phasen)

* To create a recipient value equal to 1 for a recipient, we drop all but the 
* second period recipient values (all recipients have a P2 observation)

drop recipient1 recipient3 recipient4

*   Create a variable that is the total number of hammerheads retained by the 
* vessel during the experimental period

gen total_hh = cond(missing(hh_count1), 0, hh_count1) + cond(missing(hh_count2), 0, hh_count2) + cond(missing(hh_count3), 0, hh_count3) + cond(missing(hh_count4), 0, hh_count4)

* Now let's look at some summary stats of retained hammerhead catch per vessel

summarize total_hh, detail

*   Let's total up the sum of all retained hammerhead catch by the vessels in
* the experiment over the entire experimental period.

display r(sum)

* How many are zero retained catch over the entire experiment?

count if total_hh==0

*   Only 5 vessels retained no hammerheads during the experiment. At end of 
* code, we show that these vessels did not release any hammerheads. 
* Thus we can assume they did not catch any hammerheads during the experiment.

*   Create a variable that is the total number of days in a treated or control 
* condition by each vessel during the experimental period

gen total_days = cond(missing(day_count1), 0, day_count1) + cond(missing(day_count2), 0, day_count2) + cond(missing(day_count3), 0, day_count3) + cond(missing(day_count4), 0, day_count4)

*   Now let's look at some summary stats of days of exposure per vessel 
* in the experiment (both treated and control periods).

summarize total_days, detail

*   Let's total up the sum of all days of exposure by the vessels in
* the experiment over the entire experimental period.
*   One could think of this number as the total number of vessel fishing days
* observed during the experiment via our team at the docks.

display r(sum)

* Code for the retained catch calculation for the treated periods only

*   Create a variable for each period that equals hh_count for that period 
* if the treatment status for that period ==1 and is missing otherwise.

gen hh_count_treated1 = ( hh_count1 * treatment1) if treatment1==1

gen hh_count_treated2 = ( hh_count2 * treatment2)  if treatment2==1

gen hh_count_treated3 = ( hh_count3 * treatment3)  if treatment3==1

gen hh_count_treated4 = ( hh_count4 * treatment4)  if treatment4==1

*   Now sum up the retained catch for the treated conditions by vessel
* ignoring the missing values

gen total_hh_treated = cond(missing(hh_count_treated1), 0, hh_count_treated1) + cond(missing(hh_count_treated2), 0, hh_count_treated2) + cond(missing(hh_count_treated3), 0, hh_count_treated3) + cond(missing(hh_count_treated4), 0, hh_count_treated4)

*   Any vessels that did not experience a treatment period should have their 
* total_hh_treated classified as missing not zero.

recode total_hh_treated (0=.) if (hh_count_treated1==. & hh_count_treated2==. & hh_count_treated3==. & hh_count_treated4==.)

** Summary stats and total for retained hammerheads in treated condition

summarize total_hh_treated, detail

* Sum up the total retained hammerhead catch

display r(sum)

* That value is used in the conventional M&E approach in the Results section.

* Code for calculation for the treated observations in Period 1 only

summarize hh_count_treated1, detail

display r(sum)

count if treatment1==1

*   That value is used for the conventional M&E approach in the SM related to
* the Period 1-only analysis. The number of releases for Period 1 was 
* calculated directly from the Releases1 file based on dates by Tom P.

//////////////////////////////////////////////////////////////////////////
* Count retained hh catch for each village.

summarize total_hh_treated if villagen==1

display r(sum)

summarize total_hh_treated if villagen==2

display r(sum)

summarize total_hh_treated if villagen==3

display r(sum)

summarize total_hh_treated if villagen==4

display r(sum)

summarize total_hh_treated if villagen==5

display r(sum)

///////////////////////////////////////////////////////////////////////////////
*   Code for calculation for the treated observations of three villages that
* received most of the payments (i.e., three villages in Aceh Jaya regency)

summarize total_hh_treated if (siten==1) , detail

display r(sum)

///////////////////////////////////////////////////////////////////////////////
* Code for calculation for the treated observations of payment recipients only

count if recipient2==1

* Recipients account for 29/86 observations = 34%.

summarize total_hh_treated if recipient2==1, detail

display r(sum)


* Code for retained catch calculation for the control observations only

*   Create a variable for each period that equals wf_count for that period 
* if the treatment status for that period ==0 and is missing otherwise.

gen hh_count_control1 = ( hh_count1 * (1-treatment1))

gen hh_count_control2 = ( hh_count2 * (1-treatment2))

gen hh_count_control3 = ( hh_count3 * (1-treatment3))

gen hh_count_control4 = ( hh_count4 * (1-treatment4))


*   Now sum up the retained catch for the treated conditions by vessel
* ignoring the missing values

gen total_hh_control = cond(missing(hh_count_control1), 0, hh_count_control1) + cond(missing(hh_count_control2), 0, hh_count_control2) + cond(missing(hh_count_control3), 0, hh_count_control3) + cond(missing(hh_count_control4), 0, hh_count_control4)

*   Any vessels that did not experience a control period and should have their 
* total_hh_control classified as missing not zeroes

recode total_hh_control (0=.) if (hh_count_control1==. & hh_count_control2==. & hh_count_control3==. & hh_count_control4==.)

* Summary stats and total for retained hammerheads in control condition

summarize total_hh_control, detail

display r(sum)


///////////////////////////////////////////////////////////////////////////////
* Code for calculation for the control observations of three villages that
* received most of the payments (i.e., three villages in Aceh Jaya regency)

summarize total_hh_control if (siten==1) , detail

display r(sum)

///////////////////////////////////////////////////////////////////////////
* Let's look at the total number of retained catch by the village
* that received 95% of the hammerhead payments 

summarize total_hh_control if (villagen==3), detail
display r(sum)


///////////////////////////////////////////////////////////////////////////////
* Code for calculation for the treated observations of payment recipients only

* Recipients account for 29/86 observations = 34%.

summarize total_hh_control if recipient2==1, detail

display r(sum)


save HH_Count_Totals.dta, replace

*   Now merge with the Live Release data for hammerheads

merge 1:1 boat using HH_Releases_Totals.dta

*   Recode all the missing as zeroes because all but four of them have observed
* landings during a treatment period.

recode count_hh_r (.=0)

*   There are four vessels that have no observations in the treatment condition
* and thus their live releases are missing (live releases can only happen in
* the treated condition).

recode count_hh_r (0=.) if vesseln==30

recode count_hh_r (0=.) if vesseln==31

recode count_hh_r (0=.) if vesseln==69

recode count_hh_r (0=.) if vesseln==86

save HH_Retained_and_Released_Totals.dta, replace

* Calculate the number of live releases of hammerheads 

summarize count_hh_r

display r(sum)

* Calculate the number of live releases of hammerheads in each village

summarize count_hh_r if villagen==1

display r(sum)

summarize count_hh_r if villagen==2

display r(sum)

summarize count_hh_r if villagen==3

display r(sum)

summarize count_hh_r if villagen==4

display r(sum)

summarize count_hh_r if villagen==5

display r(sum)


* The three villages that get almost all of HH and WF payments

summarize count_hh_r if siten==1

display r(sum)


* The recipients

summarize count_hh_r if recipient2==1

display r(sum)

//////////////////////////////////////////////////////////////////
* Extra stuff

*   5 vessels retained no hammerheads during the experiment. Check if
* if these vessels caught but released them.

gen nonretainer = 1 if total_hh==0

list count_hh_r if nonretainer==1

* None released a hammerhead.

//////////////////////////////////////////////////////////////////////////////
*   May be useful to know
*   Calculate days of exposure for treated observations
*   Create a variable for day_count for that period that equals day_count if 
* Treatment for that period ==1 and is missing otherwise.

gen day_count_treated1 = ( day_count1 * treatment1)

gen day_count_treated2 = ( day_count2 * treatment2)

gen day_count_treated3 = ( day_count3 * treatment3)

gen day_count_treated4 = ( day_count4 * treatment4)

* Now sum up the days of exposure for the treated conditions by vessel
* ignoring the missing values

gen total_days_treated= cond(missing(day_count_treated1), 0, day_count_treated1) + cond(missing(day_count_treated2), 0, day_count_treated2) + cond(missing(day_count_treated3), 0, day_count_treated3) + cond(missing(day_count_treated4), 0, day_count_treated4)

*   Any vessels that did not experience a treatment period should have their 
* total_days_treated classified as missing not zero.

recode total_days_treated (0=.) if (hh_count_treated1==. & hh_count_treated2==. & hh_count_treated3==. & hh_count_treated4==.)

* Summary stats and total for exposure in treated condition

summarize total_days_treated, detail

display r(sum)

*   Calculate days of exposure for control observations
*   Create a variable for day_count for that period that equals day_count if 
* Treatment for that period ==0 and is missing otherwise.

gen day_count_control1 = ( day_count1 *(1-treatment1))

gen day_count_control2 = ( day_count2 * (1-treatment1))

gen day_count_control3 = ( day_count3 * (1-treatment1))

gen day_count_control4 = ( day_count4 * (1-treatment1))

* Now sum up the days of exposure for the treated conditions by vessel
* ignoring the missing values

gen total_days_control= cond(missing(day_count_control1), 0, day_count_control1) + cond(missing(day_count_control2), 0, day_count_control2) + cond(missing(day_count_control3), 0, day_count_control3) + cond(missing(day_count_control4), 0, day_count_control4)

*   Any vessels that did not experience a treatment period should have their 
* total_days_treated classified as missing not zero.

recode total_days_treated (0=.) if (hh_count_treated1==. & hh_count_treated2==. & hh_count_treated3==. & hh_count_treated4==.)

* Summary stats and total for exposure in treated condition

summarize total_days_treated, detail

display r(sum)

save HH_Retained_and_Released_Totals.dta, replace

****************************************************************************

clear


* Wedgefish retained catches and releases over the experimental periods

import delimited DF_anly_1.csv

* Create numeric variables for the analysis

egen villagen = group(village)
egen siten = group(site)

* 1=AJ (Aceh Jaya), 2=TL (East Lombok)

egen vesseln = group(boat)

egen phasen = group(phase_exp)

*   villagen 1,4 and 5 had 4-period designs and villagen 2 and 3 had 3-period
* designs

*   Tell Stata that these data are panel data at the vessel level and that 
* phasen are the time periods in order

xtset vesseln phasen

* Drop variables that are not needed for the reshaping process

drop phase_exp hh_count hh_count_norm wf_count_norm

*   Turn the long form into wide form so that each row is a vessel and the
* and the treatment and retained catch values are arranged by period across
* the columns

reshape wide wf_count day_count treatment recipient , i(vesseln) j(phasen)

* To create a recipient value equal to 1 for a recipient, we drop all but the 
* second period recipient values (all recipients have a P2 observation)

drop recipient1 recipient3 recipient4

*   Create a variable that is the total number of wedgefish retained by the 
* vessel during the experimental period

gen total_wf = cond(missing(wf_count1), 0, wf_count1) + cond(missing(wf_count2), 0, wf_count2) + cond(missing(wf_count3), 0, wf_count3) + cond(missing(wf_count4), 0, wf_count4)

* Now let's look at some summary stats of retained wedgefish catch per vessel

summarize total_wf, detail

*   Let's total up the sum of all retained wedgefish catch by the vessels in
* the experiment over the entire experimental period.

display r(sum)

* How many are zero retained catch over the entire experiment?

count if total_wf==0

*   31 vessels retained no wedgefish during the experiment. At end of 
* code, we show that these vessels did not catch but them release any 
* wedgefish. Thus we can assume they did not catch any wedgefish during 
* the experiment.

*   Create a variable that is the total number of days in a treated or control 
* condition by each vessel during the experimental period

gen total_days = cond(missing(day_count1), 0, day_count1) + cond(missing(day_count2), 0, day_count2) + cond(missing(day_count3), 0, day_count3) + cond(missing(day_count4), 0, day_count4)

*   Now let's look at some summary stats of days of exposure per vessel 
* in the experiment (both treated and control periods).

summarize total_days, detail

*   Let's total up the sum of all days of exposure by the vessels in
* the experiment over the entire experimental period.
*   One could think of this number as the total number of vessel fishing days
* observed during the experiment via our team at the docks.

display r(sum)

* Code for the retained catch calculation for the treated periods only

*   Create a variable for each period that equals wf_count for that period 
* if the treatment status for that period ==1 and is missing otherwise.

gen wf_count_treated1 = ( wf_count1 * treatment1) if treatment1==1

gen wf_count_treated2 = ( wf_count2 * treatment2)  if treatment2==1

gen wf_count_treated3 = ( wf_count3 * treatment3)  if treatment3==1

gen wf_count_treated4 = ( wf_count4 * treatment4)  if treatment4==1

*   Now sum up the retained catch for the treated conditions by vessel
* ignoring the missing values

gen total_wf_treated = cond(missing(wf_count_treated1), 0, wf_count_treated1) + cond(missing(wf_count_treated2), 0, wf_count_treated2) + cond(missing(wf_count_treated3), 0, wf_count_treated3) + cond(missing(wf_count_treated4), 0, wf_count_treated4)

*   Any vessels that did not experience a treatment period should have their 
* total_hh_treated classified as missing not zero.

recode total_wf_treated (0=.) if (wf_count_treated1==. & wf_count_treated2==. & wf_count_treated3==. & wf_count_treated4==.)

** Summary stats and total for retained wedgefish in treated condition

summarize total_wf_treated, detail

* Sum up the total retained wedgefish catch

display r(sum)

* That value is used in the conventional M&E approach in the Results section.

* Code for calculation for the treated observations in Period 1 only

summarize wf_count_treated1, detail

display r(sum)

count if treatment1==1

*   That value is used for the conventional M&E approach in the SM related to
* the Period 1-only analysis. The number of releases for Period 1 was 
* calculated directly from the Releases1 file based on dates by Tom P.

//////////////////////////////////////////////////////////////////////////
* Count retained wf catch for each village.

summarize total_wf_treated if villagen==1

display r(sum)

summarize total_wf_treated if villagen==2

display r(sum)

summarize total_wf_treated if villagen==3

display r(sum)

summarize total_wf_treated if villagen==4

display r(sum)

summarize total_wf_treated if villagen==5

display r(sum)

///////////////////////////////////////////////////////////////////////////////
*   Code for calculation for the treated observations of three villages that
* received most of the payments (i.e., three villages in Aceh Jaya regency)

summarize total_wf_treated if (siten==1) , detail

display r(sum)

///////////////////////////////////////////////////////////////////////////////
* Code for calculation for the treated observations of payment recipients only

count if recipient2==1

* Recipients account for 29/86 observations = 34%.

summarize total_wf_treated if recipient2==1, detail

display r(sum)


* Code for retained catch calculation for the control observations only

*   Create a variable for each period that equals wf_count for that period 
* if the treatment status for that period ==0 and is missing otherwise.

gen wf_count_control1 = ( wf_count1 * (1-treatment1))

gen wf_count_control2 = ( wf_count2 * (1-treatment2))

gen wf_count_control3 = ( wf_count3 * (1-treatment3))

gen wf_count_control4 = ( wf_count4 * (1-treatment4))


*   Now sum up the retained catch for the treated conditions by vessel
* ignoring the missing values

gen total_wf_control = cond(missing(wf_count_control1), 0, wf_count_control1) + cond(missing(wf_count_control2), 0, wf_count_control2) + cond(missing(wf_count_control3), 0, wf_count_control3) + cond(missing(wf_count_control4), 0, wf_count_control4)

*   Any vessels that did not experience a control period and should have their 
* total_hh_control classified as missing not zeroes

recode total_wf_control (0=.) if (wf_count_control1==. & wf_count_control2==. & wf_count_control3==. & wf_count_control4==.)

* Summary stats and total for retained wedgefish in control condition

summarize total_wf_control, detail

display r(sum)

* How many caught zero wedgefish in the control condition?

count if total_wf_control==0
count if total_wf_control>0


///////////////////////////////////////////////////////////////////////////////
* Code for calculation for the control observations of three villages that
* received most of the payments (i.e., three villages in Aceh Jaya regency)

summarize total_wf_control if (siten==1) , detail

display r(sum)

///////////////////////////////////////////////////////////////////////////
* Let's look at the total number of retained catch by the village
* that received 95% of the hammerhead payments 

summarize total_wf_control if (villagen==3), detail
display r(sum)


///////////////////////////////////////////////////////////////////////////////
* Code for calculation for the treated observations of payment recipients only

* Recipients account for 29/86 observations = 34%.

summarize total_wf_control if recipient==1, detail

display r(sum)


save WF_Count_Totals.dta, replace

*   Now merge with the Live Release data for wedgefish

merge 1:1 boat using WF_Releases_Totals.dta

*   Recode all the missing as zeroes because all but four of them have observed
* landings during a treatment period.

recode count_wf_r (.=0)

*   There are four vessels that have no observations in the treatment condition
* and thus their live releases are missing (live releases can only happen in
* the treated condition).

recode count_wf_r (0=.) if vesseln==30

recode count_wf_r (0=.) if vesseln==31

recode count_wf_r (0=.) if vesseln==69

recode count_wf_r (0=.) if vesseln==86

save WF_Retained_and_Released_Totals.dta, replace

* Calculate the number of live releases of wedgefish 

summarize count_wf_r

display r(sum)

* Calculate the number of live releases of wedgefish in each village

summarize count_wf_r if villagen==1

display r(sum)

summarize count_wf_r if villagen==2

display r(sum)

summarize count_wf_r if villagen==3

display r(sum)

summarize count_wf_r if villagen==4

display r(sum)

summarize count_wf_r if villagen==5

display r(sum)


* The three villages that get almost all of HH and WF payments

summarize count_wf_r if siten==1

display r(sum)


* The recipients

summarize count_wf_r if recipient==1

display r(sum)

//////////////////////////////////////////////////////////////////
* Extra stuff

*   vessels retained no wedgefish during the experiment. Check if
* if these vessels caught but released them.

gen nonretainer = 1 if total_wf==0

list count_wf_r if nonretainer==1

* None released a wedgefish

//////////////////////////////////////////////////////////////////////////////
*   May be useful to know
*   Calculate days of exposure for treated observations
*   Create a variable for day_count for that period that equals day_count if 
* Treatment for that period ==1 and is missing otherwise.

gen day_count_treated1 = ( day_count1 * treatment1)

gen day_count_treated2 = ( day_count2 * treatment2)

gen day_count_treated3 = ( day_count3 * treatment3)

gen day_count_treated4 = ( day_count4 * treatment4)

* Now sum up the days of exposure for the treated conditions by vessel
* ignoring the missing values

gen total_days_treated= cond(missing(day_count_treated1), 0, day_count_treated1) + cond(missing(day_count_treated2), 0, day_count_treated2) + cond(missing(day_count_treated3), 0, day_count_treated3) + cond(missing(day_count_treated4), 0, day_count_treated4)

*   Any vessels that did not experience a treatment period should have their 
* total_days_treated classified as missing not zero.

recode total_days_treated (0=.) if (wf_count_treated1==. & wf_count_treated2==. & wf_count_treated3==. & wf_count_treated4==.)

* Summary stats and total for exposure in treated condition

summarize total_days_treated, detail

display r(sum)

*   Calculate days of exposure for control observations
*   Create a variable for day_count for that period that equals day_count if 
* Treatment for that period ==0 and is missing otherwise.

gen day_count_control1 = ( day_count1 *(1-treatment1))

gen day_count_control2 = ( day_count2 * (1-treatment1))

gen day_count_control3 = ( day_count3 * (1-treatment1))

gen day_count_control4 = ( day_count4 * (1-treatment1))

* Now sum up the days of exposure for the treated conditions by vessel
* ignoring the missing values

gen total_days_control= cond(missing(day_count_control1), 0, day_count_control1) + cond(missing(day_count_control2), 0, day_count_control2) + cond(missing(day_count_control3), 0, day_count_control3) + cond(missing(day_count_control4), 0, day_count_control4)

*   Any vessels that did not experience a treatment period should have their 
* total_days_treated classified as missing not zero.

recode total_days_treated (0=.) if (wf_count_treated1==. & wf_count_treated2==. & wf_count_treated3==. & wf_count_treated4==.)

* Summary stats and total for exposure in treated condition

summarize total_days_treated, detail

display r(sum)

save WF_Retained_and_Released_Totals.dta, replace

log close



